/*
 * Decompiled with CFR 0.152.
 */
package entities.missiles.misc;

import core.states.GameState;
import entities.Entity;
import entities.creatures.CreatureEntity;
import entities.missiles.MissileEntity;
import util.ResourceManager;

public class EzrealUltiEntity
extends MissileEntity {
    private double moveSpeed = 800.0;
    private int damage = 200;

    public EzrealUltiEntity(GameState game, int x, int y) {
        super(null, game, "missiles/ezreal_ulti", x, y);
        this.removeWhenOutOfArea = false;
        this.dx = this.moveSpeed;
    }

    @Override
    public void move(long delta) {
        super.move(delta);
        if (this.x > ResourceManager.get().getDimension().getWidth()) {
            ResourceManager.get().playSound("ezreal_ulti_finished");
            this.game.removeEntity(this);
        }
    }

    @Override
    public void collidedWith(Entity other) {
        if (other instanceof CreatureEntity) {
            this.game.removeEntity(other);
            ResourceManager.get().playSound("ezreal_ulti_hit");
            ((CreatureEntity)other).damage(this, this.damage);
        }
    }
}

